
//
// To jest przykadowy kod z podrozdziau 10.6 Obsuga bdw wejcia i wyjcia ksiki 
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

void fill_vector(istream& ist, vector<int>& v, char terminator)
// Wczytuje liczby cakowite ze strumienia ist do wektora v do chwili napotkania eof() lub znaku oznaczajcego koniec danych.
{
    int i = 0;
    while (ist >> i) v.push_back(i);
    if (ist.eof()) return;    // Dobrze: znaleziono koniec pliku.

    if (ist.bad()) error("Strumie ist jest w stanie bad."); // Uszkodzony strumie  wynosimy si std!

    if (ist.fail()) {   // Uporzdkowanie, co si da, i zgoszenie problemu.
        ist.clear();    // Wyczyszczenie stanu strumienia,
                        // aby mona byo poszuka znaku koczcego.
        char c;
        ist>>c;         // Wczytanie znaku z nadziej, e to znak koczcy.
        if (c != terminator) { // Niespodziewany znak.
            ist.unget();       // Oddanie z powrotem tego znaku.
            ist.clear(ios_base::failbit); // Ustawienie stanu na fail().
        }
    }
}

//------------------------------------------------------------------------------

int main()
try
{
    vector<int> v;
    fill_vector(cin, v, '*');
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
